package furny;

import ga.view.examples.simple.SimpleObjectIndividual;
import ga.view.examples.simple.SimpleObjectPhenotypeGenerator;
import ga.view.input.CamDragListener;
import ga.view.streaming.showroom.BoxShowRoom;
import ga.view.streaming.showroom.BoxShowRoom.LightingType;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomSettings;
import ga.view.streaming.showroom.ShowRoomSettings.ShowRoomType;

import com.jme3.app.SimpleApplication;
import com.jme3.math.Vector3f;

public class TestShowRoomCulling extends SimpleApplication {

  public TestShowRoomCulling() {
    setShowSettings(false);
  }

  @Override
  public void simpleInitApp() {
    cam.setLocation(new Vector3f(5f, 5f, 5f));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);

    // settings.putBoolean("UseHQMaterial", true);
    // settings.putBoolean("UseShadows", true);
    // settings.putBoolean("UseSSAO", true);
    // settings.putBoolean("UseLightScattering", true);

    final ShowRoomSettings srSettings = new ShowRoomSettings();
    srSettings.put(ShowRoomSettings.TYPE, ShowRoomType.BOX);
    srSettings.put(ShowRoomSettings.BOX_WIDTH, 15f);
    srSettings.put(ShowRoomSettings.BOX_LENGTH, 14f);
    srSettings.put(ShowRoomSettings.BOX_HEIGHT, 2.6f);
    srSettings.put(ShowRoomSettings.LIGHTING_TYPE, LightingType.OFFICE);

    final String file = "furny/textures/Carpet_Berber_Pattern_Gray_1.j3m";

    srSettings.put(ShowRoomSettings.FLOOR_MATERIAL, file);
    // srSettings.put(ShowRoomSettings.CEILING_MATERIAL, file);
    // srSettings.put(ShowRoomSettings.WALL_MATERIAL, file);

    final ShowRoom sr = new BoxShowRoom(assetManager, settings, srSettings);

    rootNode.attachChild(sr);

    final SimpleObjectPhenotypeGenerator gen = new SimpleObjectPhenotypeGenerator();
    gen.setAssetManager(assetManager);

    flyCam.setEnabled(false);

    new CamDragListener(cam, inputManager,
        CameraSettings.getOrthographicSettings(sr, settings));

    sr.attachChild(gen.createPhenotype(new SimpleObjectIndividual()));

    // EffectsFactory.addShadowProcessor(assetManager, settings, viewPort,
    // new Vector3f(3.0f, 2.1f, 3.0f));
    // EffectsFactory.addLightScatteringProcessor(assetManager, inputManager,
    // settings, viewPort, new Vector3f(3.0f, 1.9f, 3.0f));
    // EffectsFactory.addSSAOProcessor(assetManager, inputManager, settings,
    // viewPort);

  }

  public static void main(final String[] args) {
    new TestShowRoomCulling().start();
  }

}
